// *************************************************************************
//                            PicUSB.c
// Realizado con el compilador CCS PCWH 3.227
// *************************************************************************

#include <18F4550.h>
#fuses HSPLL,USBDIV,PLL5,CPUDIV1,VREGEN,NOWDT,NOPROTECT,NOLVP,NODEBUG
#use delay(clock=48000000)

#use        rs232(baud=9600, parity=N, xmit=PIN_C6, rcv=PIN_C7, bits=8) // Configuracin del puerto RS232



// =========================================================================
// Definiciones para la librera dinmica CCS. Para la configuracin dinmica
// hay que definir algunos valores. Estn explicados en usb.h
// =========================================================================

#define     USB_HID_DEVICE      FALSE                                   // Deshabilitamos el uso de las directivas HID
#define     USB_EP1_TX_ENABLE   USB_ENABLE_BULK                         // Activa EP1(EndPoint1) para las transferencias IN Bulk/Interrupt
#define     USB_EP1_RX_ENABLE   USB_ENABLE_BULK                         // Activa EP1(EndPoint1) para las transferencias OUT Bulk/Interrupt
#define     USB_EP1_TX_SIZE     4                                       // Tamao reservado para el Buffer Tx EndPoint1
#define     USB_EP1_RX_SIZE     32                                      // Tamao reservado para el Buffer Rx EndPoint1


// =========================================================================
// Si usamos una conexin USB con el pin de deteccin se define aqu.
// Si no lo vamos a utilizar borramos la lnea (O la ponemos como comentario)
// Sin el pin de deteccin no podemos saber si el perifrico est desconectado.
// Si decidimos utilizarlo la conexin sera como sta:
//
//            VBUS-----+----/\/\/\/\/\----- (I/O Pin en el PIC)
//                     |
//                     +----/\/\/\/\/\----- GND
//                             100k
//        (Donde VBUS es el Pin1 del conector USB)
// =========================================================================

//#define USB_CON_SENSE_PIN PIN_B2                                      // Podra ser el pin B2

// =========================================================================
// Includes de las libreras USB del compilador CCS.
// Se puede ver ms informacin en el comienzo de los ficheros includos
// =========================================================================

#include    <pic18_usb.h>                                               // Microchip PIC18Fxx5x Hardware para el CCS PIC USB Driver
#include    <PicUSB.h>                                                  // Configuracin del USB y los descriptores para este dispositivo
#include    <usb.c>                                                     // Handles usb ,tokens y descriptores
#include    <lcd_ET4550.c>

// =========================================================================
// Al conectar el PicUSB al PC encendemos el Led Rojo hasta que el dispositivo
// halla sido configurado por el PC, en ese momento encederemos el Led Verde.
//
// Esperaremos hasta que se reciba un paquete desde el PC. Comprobaremos
// el primer byte del paquete recibido para comprobar si queremos entrar en el
// modo Suma, donde se realizar una suma de dos operandos, que corresponderan
// con los dos bytes restantes del paquete recibido; una vez realizada la suma
// enviaremos el paquete con el resultado de vuelta al PC.
// Si entramos en el modo Led comprobaremos el segundo byte del paquete recibido
// para comprobar si deberemos apagar los leds, encender el verde o el rojo.
// =========================================================================

#define     LED0            PIN_B7                                      // PORTB.7 Led rojo
#define     LED1            PIN_B6                                      // PORTB.6 Led verde
#define     LED2            PIN_B5                                      // PORTB.7 Led rojo
#define     LED3            PIN_B4                                      // PORTB.6 Led verde

#define     PWW             PIN_C0                                      // PORTC.0 Pulso PWW

#define     LED_ON          output_low                                 // Salida en alto
#define     LED_OFF         output_high                                 // Salida en bajo
#define     CAMBIA_LED      output_toggle                               // Conmuta salida

#define     PULSO_OFF       output_low                                  // Salida en bajo
#define     PULSO_ON        output_high                                 // Salida en alto

#define     modo            recibe[0]                                   // Byte que indica el modo de operacin
#define     param1          recibe[1]                                   // Primer parmetro recibdo
#define     param2          recibe[2]                                   // Segundo parmetro recibdo

#define     resultado       envia[0]                                    // Byte a envar en la suma

#define     entrada_0       envia[0]                                    // Byte a envar en las entradas
#define     entrada_1       envia[1]                                    // Byte a envar en las entradas
#define     entrada_2       envia[2]                                    // Byte a envar en las entradas
#define     entrada_3       envia[3]                                    // Byte a envar en las entradas

#define     SUMA            0                                           // Modo suma
#define     ENCIENDE_LED    1                                           // Modo de encender leds
#define     APAGA_LED       2                                           // Modo de apagar leds
#define     ENTRADAS        3                                           // Modo de leer las entradas
#define     ANALOGICAS      4                                           // Modo de leer las entradas analogicas
#define     CONTROLPWW      5                                           // Modo de asignar el valor de PWW
#define     USB_TO_LCD      6

void main(void)                                                         // Funcin Principal
{
    int8    recibe[64];                                                  // Declaramos la variable recibe de 3 bytes
    int8    LCD_Buf[32];
    int8    envia[4];                                                   // Declaramos la variable enva de 4 bytes
    int8    valorPWW=0;                                                 // Valor del pulso PWW
    int8    i,j,k;                                                          // Indice del bucle PWW

    set_tris_b(0x0F);                                                   // Nibble bajo entradas, el alto salidas

    setup_adc_ports(AN0_TO_AN3);                                        // Asigna el conversor A/D
    setup_adc(ADC_CLOCK_INTERNAL);                                      // Asigna la velocidad

    LED_ON(LED0);                                                       // Encendemos led rojo
    LED_OFF(LED1);                                                      // Apagamos el resto
    LED_OFF(LED2);                                                      // Apagamos el resto
    LED_OFF(LED3);                                                      // Apagamos el resto

    PULSO_OFF(PWW);                                                     // Pulso en bajo

    lcd_init();
    delay_ms(100);
     lcd_putc("\fET-PICUSB4550");


    usb_init();                                                         // Inicializamos el USB

    usb_task();                                                         // Habilita el periferico usb y las interrupciones
    usb_wait_for_enumeration();                                         // Esperamos hasta que el PicUSB sea configurado por el PC

    LED_OFF(LED0);                                                      // Apagamos el led rojo
    LED_ON(LED1);                                                       // Y encendemos led verde



    while (TRUE)                                                        // Se cumple siempre (Bucle infinito)
    {
        if(usb_enumerated())                                            // Si el PicUSB est configurado
        {
            if (valorPWW!=0)                                            // Si valorPWW no es cero
            {
               PULSO_OFF(PWW);
               for (i=0;i<valorPWW;i++) delay_us(10);
               PULSO_ON(PWW);
               for (i=0;i<valorPWW;i++) delay_us(10);
            }
            else
            {
                PULSO_OFF(PWW);                                         // Pulso en bajo si valorPWW es cero
            }

            if (usb_kbhit(1))                                           // Si el EndPoint de salida contiene datos del PC
            {
                usb_get_packet(1, recibe, 64);                           // Cojemos el paquete de tamao 3 bytes del EP1



                if (modo==SUMA)                                         // Modo Suma
                {
                    resultado=param1+param2;                            // Hacemos la suma
                    usb_put_packet(1,envia,4,USB_DTS_TOGGLE);           // Enviamos el paquete de tamao 4 bytes del EP1 al PC
                }

                if (modo==ENCIENDE_LED)                                 // Modo Encender Leds
                {
                    if (param1==1) {LED_ON(LED0);}                      // Encendemos led 0
                    if (param1==2) {LED_ON(LED1);}                         // Encendemos led 1
                    if (param1==3) {LED_ON(LED2);}                         // Encendemos led 2
                    if (param1==4) {LED_ON(LED3);}                         // Encendemos led 3
                }

                if (modo==APAGA_LED)                                    // Modo Apagar Leds
                {
                    if (param1==1) {LED_OFF(LED0);}                        // Apagamos led 0
                    if (param1==2) {LED_OFF(LED1);}                        // Apagamos led 1
                    if (param1==3) {LED_OFF(LED2);}                        // Apagamos led 2
                    if (param1==4) {LED_OFF(LED3);}                        // Apagamos led 3
                }

                if (modo==ENTRADAS)                                     // Modo de leer las entradas
                {
                    entrada_0=input(PIN_B0);                            // Entrada B0
                    entrada_1=input(PIN_B1);                            // Entrada B1
                    entrada_2=input(PIN_B2);                            // Entrada B2
                    entrada_3=input(PIN_B3);                            // Entrada B3
                    usb_put_packet(1,envia,4,USB_DTS_TOGGLE);           // Enviamos el paquete de tamao 4 bytes del EP1 al PC
                }

                if (modo==ANALOGICAS)                                   // Modo de leer las entradas analgicas
                {
                    set_adc_channel(0);                                 // Canal A0
                    delay_us(10);                                       // Retardo
                    entrada_0 = read_adc();                             // Lee el valor

                    set_adc_channel(1);                                 // Canal A1
                    delay_us(10);                                       // Retardo
                    entrada_1 = read_adc();                             // Lee el valor

                    set_adc_channel(2);                                 // Canal A2
                    delay_us(10);                                       // Retardo
                    entrada_2 = read_adc();                             // Lee el valor

                    set_adc_channel(3);                                 // Canal A3
                    delay_us(10);                                       // Retardo
                    entrada_3 = read_adc();                             // Lee el valor

                    usb_put_packet(1,envia,4,USB_DTS_TOGGLE);           // Enviamos el paquete de tamao 4 bytes del EP1 al PC
                }

                if (modo==CONTROLPWW)                                   // Modo de control PWW
                {
                    valorPWW=param1;                                    // Asignamos el valor del PWW
                }

                if (modo==USB_TO_LCD)
                {

                    for (i=1;i<17;i++)
                    {
                    LCD_Buf[i] = recibe[i];
                   // printf("%d ",LCD_Buf[i]);
                    putc (LCD_Buf[i]);
                    }

                    lcd_gotoxy(1,2);

                    for (i=1;i<17;i++)
                    {

                //    printf(lcd_putc,"%s",LCD_Buf[i]);
                    
                    lcd_putc (LCD_Buf[i]);
                     
                    }
                }

            }
        }
    }
}
